/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.path;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.conndata.AccountingInfo;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class CallHomePath
extends RcsPath {
    private static final String TRACE_MASKT = "XRCSCHPT";
    private static final String TRACE_MASKF = "XRCSCHPF";
    private static final String TRACE_MASKD = "XRCSCHPD";
    private static final String PATH_DESC_ID = "CallHomePath";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$AttLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink;

    public CallHomePath() {
        this(PathPlatform.GENERIC, PathPriority.LOW, new LocalizableText(PATH_DESC_ID));
    }

    public CallHomePath(PathPlatform platform) {
        this(platform, PathPriority.LOW, new LocalizableText(PATH_DESC_ID));
    }

    public CallHomePath(PathPriority priority) {
        this(PathPlatform.GENERIC, priority, new LocalizableText(PATH_DESC_ID));
    }

    public CallHomePath(LocalizableText text) {
        this(PathPlatform.GENERIC, PathPriority.LOW, text);
    }

    public CallHomePath(PathPlatform platform, PathPriority priority) {
        this(platform, priority, new LocalizableText(PATH_DESC_ID));
    }

    public CallHomePath(PathPlatform platform, LocalizableText text) {
        this(platform, PathPriority.LOW, text);
    }

    public CallHomePath(PathPlatform platform, PathPriority priority, LocalizableText text) {
        super(platform, priority, text);
        ArrayList<Class> links = new ArrayList<Class>();
        links.add(class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink == null ? (class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink = CallHomePath.class$("com.ibm.hwmca.fw.rcs.link.InternetVpnLink")) : class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink);
        links.add(class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink == null ? (class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink = CallHomePath.class$("com.ibm.hwmca.fw.rcs.link.L2tpVpnLink")) : class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink);
        links.add(class$com$ibm$hwmca$fw$rcs$link$AttLink == null ? (class$com$ibm$hwmca$fw$rcs$link$AttLink = CallHomePath.class$("com.ibm.hwmca.fw.rcs.link.AttLink")) : class$com$ibm$hwmca$fw$rcs$link$AttLink);
        links.add(class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink == null ? (class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink = CallHomePath.class$("com.ibm.hwmca.fw.rcs.link.L2tpAttLink")) : class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink);
        this.setSupportedLinkTypes(links);
    }

    public void open() throws InvalidStateException, PathCancelledException, PathFailedException {
        Trace.trace(TRACE_MASKT, "--> open()");
        CustomerInfoData custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        String country = custData.getSystemCountryCode();
        String region = custData.getSystemSubdivisionCode();
        ConnectionInfoManager connInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
        AccountingInfo acctInfo = connInfoMgr.getConnectionInfoManager().getAccountingInfo(this.platform, country, region);
        AccountInfo attInfo = acctInfo.getAccountInfo("Account_URSF");
        if (attInfo == null) {
            String msg = "Accounting information unavailable for " + country + ", " + region;
            Trace.trace(TRACE_MASKF, msg);
            super.close();
            throw new PathFailedException(msg);
        }
        String attAccount = attInfo.getAccount();
        String attUserId = attInfo.getUserId();
        String user = "internet." + attAccount + "." + attUserId;
        RcsConfig.getRcsConfig().setTemporaryConfigValue("att_auth_user", user);
        super.open();
        connInfoMgr.refreshUpdatableFiles(false);
        Trace.trace(TRACE_MASKT, "<-- open()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

